<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


/**
 * Includes the Base files
 *
 */
function wpsbc_include_files_base() {

	// Get legend dir path
	$dir_path = plugin_dir_path( __FILE__ );

	// Include languages functions
	if( file_exists( $dir_path . 'functions-languages.php' ) )
		include $dir_path . 'functions-languages.php';

	// Include utils functions
	if( file_exists( $dir_path . 'functions-utils.php' ) )
		include $dir_path . 'functions-utils.php';

	// Include update functions
	if( file_exists( $dir_path . 'functions-update.php' ) )
		include $dir_path . 'functions-update.php';

	// Include the shortcodes class
	if( file_exists( $dir_path . 'class-shortcodes.php' ) )
		include $dir_path . 'class-shortcodes.php';

	// Include the widget class
	if( file_exists( $dir_path . 'class-widget-calendar.php' ) )
		include $dir_path . 'class-widget-calendar.php';

	// Include the widget class
	if( file_exists( $dir_path . 'class-widget-calendar-search.php' ) )
		include $dir_path . 'class-widget-calendar-search.php';

	// Include the Customizer class
	if (file_exists($dir_path . 'class-customizer.php')) {
		include $dir_path . 'class-customizer.php';
	}

}
add_action( 'wpsbc_include_files', 'wpsbc_include_files_base' );


/**
 * Returns an array with the weekdays
 *
 * @return array
 *
 */
function wpsbc_get_weekdays() {

	$weekdays = array(
		__( 'Monday', 'wp-simple-booking-calendar' ),
		__( 'Tuesday', 'wp-simple-booking-calendar' ),
		__( 'Wednesday', 'wp-simple-booking-calendar' ),
		__( 'Thursday', 'wp-simple-booking-calendar' ),
		__( 'Friday', 'wp-simple-booking-calendar' ),
		__( 'Saturday', 'wp-simple-booking-calendar' ),
		__( 'Sunday', 'wp-simple-booking-calendar' )
	);

	return $weekdays;

}

/**
 * Returns true if there are any active languages in settings, false if not.
 *
 * @return bool
 *
 */
function wpsbc_translations_active($language = false)
{

    $settings = get_option('wpsbc_settings', array());

    if (!isset($settings['active_languages'])) {
        return false;
    }

    if (empty($settings['active_languages'])) {
        return false;
    }

    if ($language !== false && !in_array($language, $settings['active_languages'])) {
        return false;
    }

    return true;

}