<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Includes the Search Widget files
 *
 */
function wpsbc_include_files_search_widget()
{

    // Get legend dir path
    $dir_path = plugin_dir_path(__FILE__);

    // Include the shortcodes class
    if (file_exists($dir_path . 'class-search-widget-outputter.php')) {
        include $dir_path . 'class-search-widget-outputter.php';
    }

    // Include the ajax functions
    if (file_exists($dir_path . 'functions-ajax.php')) {
        include $dir_path . 'functions-ajax.php';
    }
}
add_action('wpsbc_include_files', 'wpsbc_include_files_search_widget');

/**
 * Default Search Widget strings
 *
 */
function wpsbc_search_widget_default_strings()
{
    return array(
        'widget_title' => __('Search', 'wp-simple-booking-calendar'),
        'start_date_label' => __('Start Date', 'wp-simple-booking-calendar'),
        'start_date_placeholder' => __('', 'wp-simple-booking-calendar'),
        'end_date_label' => __('End Date', 'wp-simple-booking-calendar'),
        'end_date_placeholder' => __('', 'wp-simple-booking-calendar'),
        'search_button_label' => __("Search", 'wp-simple-booking-calendar'),
        'no_start_date' => __("Please select a starting date.", 'wp-simple-booking-calendar'),
        'no_end_date' => __("Please select an ending date.", 'wp-simple-booking-calendar'),
        'invalid_start_date' => __("Invalid start date.", 'wp-simple-booking-calendar'),
        'invalid_end_date' => __("Invalid end date", 'wp-simple-booking-calendar'),
        'results_title' => __("Search Results", 'wp-simple-booking-calendar'),
        'no_results' => __("No available dates were found.", 'wp-simple-booking-calendar'),
        'view_button_label' => __("View", 'wp-simple-booking-calendar'),
        'label_previous' => __("Previous", 'wp-simple-booking-calendar'),
        'label_next' => __("Next", 'wp-simple-booking-calendar'),
    );
}

/**
 * Returns the default arguments for the calendar outputter
 *
 * @return array
 *
 */
function wpsbc_get_search_widget_default_args()
{
    $args = array(
        'calendars' => 'all',
        'language' => 'auto',
        'title' => 'yes',
        'start_day' => 1,
        'selection_type' => 'multiple',
        'minimum_stay' => 0,
        'featured_image' => 'no',
        'results_layout' => 'list',
        'results_per_page' => 10,
        'show_results_on_load' => 'no',
        'redirect' => ''
    );

    return $args;
}

/**
 * Check if a date range in a calendar is available.
 *
 * @param int $calendar_id
 * @param string $start_date Ymd
 * @param string $end_date Ymd
 *
 * @return bool
 *
 */

function wpsbc_check_if_date_range_is_bookable($calendar_id, $start_date, $end_date)
{
    // Get non bookable legend items
    $non_bookable_legend_items = array();
    $legend_items = wpsbc_get_legend_items(array('calendar_id' => $calendar_id));
    $changeover_start = $changeover_end = false;

    foreach ($legend_items as $legend_item) {
        if ($legend_item->get('is_bookable') == 0) {
            $non_bookable_legend_items[] = $legend_item->get('id');
        }

        if ($legend_item->get('changeover_type') == 'start') {
            $changeover_start = $legend_item->get('id');
        }

        if ($legend_item->get('changeover_type') == 'end') {
            $changeover_end = $legend_item->get('id');
        }
    }

    $changeover_start_found = false;

    // Loop through events
    $calendar_events = wpsbc_get_events(array('calendar_id' => $calendar_id)); // Calendar Events
    $ical_events = wpsbc_get_ical_feeds_as_events($calendar_id, array()); // iCalendar Events

    $events = array_merge($calendar_events, $ical_events);

    foreach ($events as $event) {

        $event_legend_item_id = $event->get('legend_item_id') == null ? -1 : $event->get('legend_item_id');

        // Format the event's date
        $event_date = date('Ymd', mktime(0, 0, 0, $event->get('date_month'), $event->get('date_day'), $event->get('date_year')));

        // If event date is outside search range, continue;
        if ($event_date < $start_date || $event_date > $end_date) {
            continue;
        }

        // Check if the event found is not bookable
        if (in_array($event_legend_item_id, $non_bookable_legend_items)) {
            return false;
        }

        // Check for changeovers. The rule is that if a start changeover exists in an array, we shouln't an end changeover

        // We found a starting changeover date
        if ($event_legend_item_id == $changeover_start) {
            $changeover_start_found = true;
        }

        // Now if we find an ending changeover date and a starting changeover date was previously found, we mark the date as not available.
        if ($event_legend_item_id == $changeover_end && $changeover_start_found === true) {
            return false;
        }
    }

    return true;
}
