<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


/**
 * Registers the Multiple Overview Calendar block
 *
 */
if( function_exists( 'register_block_type' ) ) {

	function wpsbc_register_block_type_overview_calendar() {

		wp_register_script( 'wpsbc-script-block-overview-calendar', WPSBC_PLUGIN_DIR_URL . 'includes/modules/blocks/overview-calendar/assets/js/build/script-block-overview-calendar.js', array( 'wp-blocks', 'wp-element', 'wp-editor', 'wp-i18n' ) );

		register_block_type( 
			'wp-simple-booking-calendar/overview-calendar', 
			array(
				'attributes' => array(
					'calendars' => array(
						'type' => 'string'
					),
					'legend' => array(
						'type' => 'string'
					),
					'legend_position' => array(
						'type' => 'string'
					),
					'start_year' => array(
						'type' => 'string'
					),
					'start_month' => array(
						'type' => 'string'
					),
					'history' => array(
						'type' => 'string'
					),
					'tooltip' => array(
						'type' => 'string'
					),
					'weeknumbers' => array(
						'type' => 'string'
					),
					'language' => array(
						'type' => 'string'
					)
				),
				'editor_script'   => 'wpsbc-script-block-overview-calendar', 
				'render_callback' => 'wpsbc_block_to_shortcode_overview_calendar'
			)	
		);

	}
	add_action( 'init', 'wpsbc_register_block_type_overview_calendar' );

}


/**
 * Render callback for the server render block
 * Transforms the attributes from the blocks into the needed shortcode arguments
 *
 * @param array $args
 *
 * @return string
 *
 */
function wpsbc_block_to_shortcode_overview_calendar( $args ) {

	// Transform the values for the calendars
	if( ! empty( $args['calendars'] ) ) {

		$calendars = json_decode( $args['calendars'], true );

		foreach( $calendars as $key => $value ) {

			$calendars[$key] = $value['value'];

		}

		$args['calendars'] = implode( ',', $calendars );

	}
	
	// Execute the shortcode
	return WPSBC_Shortcodes::calendar_overview( $args );

}