<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

$user_roles = get_editable_roles();

?>

<!-- User Role Permissions -->
<div class="wpsbc-settings-field-wrapper wpsbc-settings-field-inline">

	<label class="wpsbc-settings-field-label"><?php echo __( 'User Role Permissions', 'wp-simple-booking-calendar' ); ?><?php echo wpsbc_get_output_tooltip( __( 'Select the user roles you wish to have calendar editing capabilities. All users that have the selected user roles will be able to edit all calendars.', 'wp-simple-booking-calendar' ) ); ?></label>

	<div class="wpsbc-settings-field-inner wpsbc-chosen-wrapper">

		<select multiple name="wpsbc_settings[user_role_permissions][]" class="wpsbc-chosen">
			<?php 
				foreach( $user_roles as $user_role_slug => $user_role ) {

					if( $user_role_slug == 'administrator' )
						continue;

					echo '<option value="' . esc_attr( $user_role_slug ) . '" ' . ( ! empty( $settings['user_role_permissions'] ) && in_array( $user_role_slug, $settings['user_role_permissions'] ) ? 'selected' : '' ) . '>' . $user_role['name'] . '</option>';

				}
			?>
		</select>

	</div>
	
</div>