<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

$calendar_id = ( ! empty( $_GET['calendar_id'] ) ? absint( $_GET['calendar_id'] ) : 0 );
$calendar    = wpsbc_get_calendar( $calendar_id );

$legend_items 		 = wpsbc_get_legend_items( array( 'calendar_id' => $calendar_id ) );
$export_legend_items = wpsbc_get_calendar_meta( $calendar_id, 'ical_export_legend_items', true );
$group_events_by_description = wpsbc_get_calendar_meta( $calendar_id, 'group_events_by_description', true );

if( empty( $export_legend_items ) )
	$export_legend_items = array();

$ical_status = wpsbc_get_calendar_meta($calendar_id, 'disable_icalendar_links', true);

?>

<div class="wrap wpsbc-wrap">

	<!-- Page Heading -->
	<h1 class="wp-heading-inline"><?php echo __( 'iCal Import/Export', 'wp-simple-booking-calendar' ); ?><span class="wpsbc-heading-tag"><?php printf( __( 'Calendar ID: %d', 'wp-simple-booking-calendar' ), $calendar_id ); ?></span></h1>
	
	<!-- Page Heading Actions -->
	<div class="wpsbc-heading-actions">
		<a href="<?php echo add_query_arg( array( 'subpage' => 'edit-calendar' ) ); ?>" class="button-secondary"><?php echo __( 'Back to Calendar', 'wp-simple-booking-calendar' ); ?></a>
	</div>

	<hr class="wp-header-end" />

	<!-- Dashboard Widgets Wrapper -->
	<div>

		<div id="dashboard-widgets" class="metabox-holder">

			<!-- Row -->
			<div class="wpsbc-row">

				<!-- Col 1-1 -->
				<div class="wpsbc-col-1-1">

					<!-- Postbox Export -->
					<div class="postbox" style="margin-bottom: 0;">

						<form method="POST" action="">

							<h2 class="hndle"><span class="dashicons dashicons-upload"></span>&nbsp;&nbsp;<?php echo __( 'Export', 'wp-simple-booking-calendar' ); ?></h2>

							<!-- Form Fields -->
							<div class="inside">

								<!-- iCal Feed Link -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label"><?php echo __( 'iCalendar Link', 'wp-simple-booking-calendar' ); ?></label>

									<div class="wpsbc-settings-field-inner">
										<input id="wpsbc-settings-field-ical-export" readonly type="text" value="<?php echo add_query_arg( array( 'wpsbc-ical' => $calendar->get('ical_hash') ), site_url() . '/' ); ?>.ics" />
									</div>
									
								</div>

								<!-- Export as Booked Legend Items -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label"><?php echo __( 'Legend Items to Export as Booked', 'wp-simple-booking-calendar' ); ?></label>

									<div class="wpsbc-settings-field-inner wpsbc-chosen-wrapper">

										<select multiple class="wpsbc-chosen" name="ical_export_legend_items[]" id="ical-export-legend-items">
											<?php 
												foreach( $legend_items as $legend_item ) {
													echo '<option value="' . esc_attr( $legend_item->get('id') ) . '" ' . ( in_array( $legend_item->get('id'), $export_legend_items ) ? 'selected' : '' ) . '>' . $legend_item->get('name') . '</option>';
												}
											?>
										</select>

										<div class="wpsbc-warning" style="display:none;"><span class="dashicons dashicons-info"></span> <?php echo __('When exporting changeover days, do not include the ending changeover in the list above.', 'wp-simple-booking-calendar') ?></div>

									</div>

								</div>

								<!-- Group events by description -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label">
										<?php echo __( 'Group Events by Description', 'wp-simple-booking-calendar' ); ?>
										<?php echo wpsbc_get_output_tooltip( __( 'If selected, events that have the same description will be grouped into one event spaning over multiple days.', 'wp-simple-booking-calendar' ) ); ?>
									</label>

									<div class="wpsbc-settings-field-inner">

										<label for="group_events_by_description">
											<input type="checkbox" id="group_events_by_description" name="group_events_by_description" value="1" <?php checked( '1', $group_events_by_description ); ?>  >
											Yes
										</label>


									</div>

								</div>
							
							</div>

							<!-- Card Bottom -->
							<div class="wpsbc-plugin-card-bottom plugin-card-bottom">
								<a class="button-secondary" onclick="return confirm('<?php echo __( 'Are you sure you want to reset the iCalendar feed link for this calendar?', 'wp-simple-booking-calendar' ); ?>' )" href="<?php echo ( wp_nonce_url( add_query_arg( array( 'wpsbc_action' => 'reset_private_link' ), remove_query_arg( 'wpsbc_message' ) ), 'wpsbc_reset_private_link', 'wpsbc_token' ) ); ?>"><?php echo __( 'Reset Private Link', 'wp-simple-booking-calendar' ); ?></a>
								<input type="submit" class="button-primary wpsbc-float-right" value="<?php echo __( 'Save Preferences', 'wp-simple-booking-calendar' ); ?>" />
							</div>

							<!-- Calendar ID -->
							<input type="hidden" name="calendar_id" value="<?php echo $calendar_id; ?>" />

							<!-- Nonce -->
							<?php wp_nonce_field( 'wpsbc_ical_export_save_preferences', 'wpsbc_token', false ); ?>
							<input type="hidden" name="wpsbc_action" value="ical_export_save_preferences" />

						</form>

					</div>

				</div>

			</div><!-- / Row -->

			<!-- Row -->
			<div class="wpsbc-row">

				<!-- Col 1-2 -->
				<div class="wpsbc-col-1-2">

					<!-- Postbox Import from File -->
					<div class="postbox">

						<form id="wpsbc-ical-file-import" enctype="multipart/form-data" method="POST" action="">

							<h2 class="hndle">
								<span class="dashicons dashicons-download"></span>&nbsp;&nbsp;<?php echo __( 'Import from File', 'wp-simple-booking-calendar' ); ?>
								<?php echo wpsbc_get_output_tooltip( __( 'Importing from a .ics file will insert the iCal events into the calendar. You will then be able to edit the details for each imported date.', 'wp-simple-booking-calendar' ) ); ?>
							</h2>

							<!-- Form Fields -->
							<div class="inside">

								<!-- iCal File -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label"><?php echo __( 'iCalendar File', 'wp-simple-booking-calendar' ); ?> *</label>

									<div class="wpsbc-settings-field-inner">
										<input id="wpsbc-settings-field-ical-file" name="ical_file_import_file" type="file" value="" />
									</div>
									
								</div>

								<!-- Set Legend Item -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label">
										<?php echo __( 'Import iCal Events As', 'wp-simple-booking-calendar' ); ?> *
										<?php echo wpsbc_get_output_tooltip( __( 'The dates from the iCal events present in the file will be assigned the legend item that you choose here.', 'wp-simple-booking-calendar' ) ); ?>
									</label>

									<div class="wpsbc-settings-field-inner">

										<select name="ical_file_import_legend_item_default">
											<option value=""><?php echo __( 'Select...', 'wp-simple-booking-calendar' ); ?></option>
											<?php 
												foreach( $legend_items as $legend_item ) {
													echo '<option value="' . absint( $legend_item->get('id') ) . '">' . $legend_item->get('name') . '</option>';
												}
											?>
										</select>

									</div>

								</div>

								<!-- Overwrite existing -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label">
										<?php echo __( 'Overwrite Existing Dates', 'wp-simple-booking-calendar' ); ?> *
										<?php echo wpsbc_get_output_tooltip( __( 'Select whether or not to overwrite data for dates in the calendar that already contain information. Selecting "Overwrite" will add all events present in the iCal file, regardless of the existing information for the calendar dates. Selecting "Skip" will add data only for dates that do not have any information set.', 'wp-simple-booking-calendar' ) ); ?>
									</label>

									<div class="wpsbc-settings-field-inner">

										<select name="ical_import_file_overwrite">
											<option value=""><?php echo __( 'Select...', 'wp-simple-booking-calendar' ); ?></option>
											<option value="overwrite"><?php echo __( 'Overwrite', 'wp-simple-booking-calendar' ); ?></option>
											<option value="skip"><?php echo __( 'Skip', 'wp-simple-booking-calendar' ); ?></option>
										</select>

									</div>

								</div>

								<!-- Description Import -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label">
										<?php echo __( 'Description Import', 'wp-simple-booking-calendar' ); ?> *
										<?php echo wpsbc_get_output_tooltip( __( 'Select how you wish the description of each event from the .ics file to be imported into the plugin.', 'wp-simple-booking-calendar' ) ); ?>
									</label>

									<div class="wpsbc-settings-field-inner">

										<select name="ical_import_file_description">
											<option value=""><?php echo __( 'Select...', 'wp-simple-booking-calendar' ); ?></option>
											<option value="only_description"><?php echo __( 'Import only in the description field', 'wp-simple-booking-calendar' ); ?></option>
											<option value="only_tooltip"><?php echo __( 'Import only in the tooltip field', 'wp-simple-booking-calendar' ); ?></option>
											<option value="both"><?php echo __( 'Import in both description and tooltip fields', 'wp-simple-booking-calendar' ); ?></option>
											<option value="none"><?php echo __( 'Do not import the description', 'wp-simple-booking-calendar' ); ?></option>
										</select>

									</div>

								</div>
							
							</div>

							<!-- Card Bottom -->
							<div class="wpsbc-plugin-card-bottom plugin-card-bottom">
								<input type="submit" disabled class="button-primary wpsbc-float-right" value="<?php echo __( 'Import iCal File', 'wp-simple-booking-calendar' ); ?>" />
								<div class="clear"><!-- --></div>
							</div>

							<!-- Calendar ID -->
							<input type="hidden" name="calendar_id" value="<?php echo $calendar_id; ?>" />

							<!-- Nonce -->
							<?php wp_nonce_field( 'wpsbc_ical_import_file', 'wpsbc_token', false ); ?>
							<input type="hidden" name="wpsbc_action" value="ical_import_file" />

						</form>

					</div>

				</div><!-- / Col-1-2 -->

				<!-- Col 1-2 -->
				<div class="wpsbc-col-1-2">

					<!-- Postbox Import from iCal URL -->
					<div class="postbox">

						<form id="wpsbc-ical-url-import" method="POST" action="">

							<?php $ical_feeds = wpsbc_get_calendar_meta_ical_feeds( $calendar_id ); ?>

							<h2 class="hndle">
								<span class="dashicons dashicons-download"></span>&nbsp;&nbsp;<?php echo __( 'Import from iCal URL', 'wp-simple-booking-calendar' ); ?>
								<?php echo wpsbc_get_output_tooltip( __( 'Importing from an iCal URL will overlay the events from the URL. You will not be able to edit these events.', 'wp-simple-booking-calendar' ) ); ?>

								<?php if(empty($ical_status) || $ical_status != true): ?>
									<a class="wpsbc-ical-import-disable" href="<?php echo wp_nonce_url( add_query_arg( array( 'page' => 'wpsbc-calendars', 'wpsbc_action' => 'disable_icalendar_links', 'calendar_id' => $calendar_id ) , admin_url( 'admin.php' ) ), 'wpsbc_disable_icalendar_links', 'wpsbc_token' );?>"><?php echo __( 'Disable iCalendar Links', 'wp-simple-booking-calendar' ); ?></a>
								<?php else: ?>
									<a class="wpsbc-ical-import-disable" href="<?php echo wp_nonce_url( add_query_arg( array( 'page' => 'wpsbc-calendars', 'wpsbc_action' => 'enable_icalendar_links', 'calendar_id' => $calendar_id ) , admin_url( 'admin.php' ) ), 'wpsbc_enable_icalendar_links', 'wpsbc_token' );?>"><?php echo __( 'Enable iCalendar Links', 'wp-simple-booking-calendar' ); ?></a>
								<?php endif; ?>

							</h2>

							<div class="wpsbc-ical-url-import-wrapper <?php if(!empty($ical_status) && $ical_status == true): ?>disabled<?php endif;?>">

								<?php if( empty( $ical_feeds ) ): ?>

									<div class="inside" style="border-bottom: 1px solid #eee;">

										<p><?php echo __( "You don't have any iCal URL's included. Use the form below to add an iCal feed URL.", 'wp-simple-booking-calendar' ); ?></p>

									</div>

								<?php else: ?>

									<?php foreach( $ical_feeds as $ical_feed ): ?>

										<div class="wpsbc-ical-feed-calendar">

											<?php 
												$disabled = (isset($ical_feed['disabled']) && $ical_feed['disabled'] == true) ? true : false;
												$legend_item = wpsbc_get_legend_item( $ical_feed['legend_item_id'] );
												
												if(!is_null($legend_item)){
													echo wpsbc_get_legend_item_icon( $legend_item->get('id'), $legend_item->get('type'), $legend_item->get('color') );
												}
											?>

											<div class="wpsbc-ical-feed-calendar-inner wpsbc-ical-feed-calendar-inner-<?php echo $disabled ? 'disabled' : 'enabled';?>">
												<strong><?php echo $ical_feed['name']; ?></strong>
												<p title="<?php echo esc_attr( $ical_feed['url'] ); ?>"><?php echo esc_attr( $ical_feed['url'] ); ?></p>
												<small><?php echo sprintf( __( 'Last updated: %s' ), date( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $ical_feed['last_updated'] ) ) ); ?></small>
												<?php if(!$legend_item): ?>
													<span class="wpsbc-ical-error"><?php echo __('The legend item assigned to this iCalendar link no longer exists.', 'wp-simple-booking-calendar') ?></span>
												<?php endif; ?>
											</div>

											<a href="<?php echo wp_nonce_url( add_query_arg( array( 'wpsbc_action' => 'toggle_ical_feed', 'ical_feed_id' => $ical_feed['id'] ) ), 'wpsbc_toggle_ical_feed', 'wpsbc_token' ); ?>" class="wpsbc-disable"><?php echo $disabled ? __( 'Enable', 'wp-simple-booking-calendar' ) : __( 'Disable', 'wp-simple-booking-calendar' ); ?></a>

											<a onclick="return confirm('<?php echo __( 'Are you sure you want to remove this iCal URL?', 'wp-simple-booking-calendar' ); ?>');" href="<?php echo wp_nonce_url( add_query_arg( array( 'wpsbc_action' => 'remove_ical_feed', 'ical_feed_id' => $ical_feed['id'] ), remove_query_arg( 'wpsbc_message' ) ), 'wpsbc_remove_ical_feed', 'wpsbc_token' ); ?>" class="wpsbc-trash"><?php echo __( 'Remove', 'wp-simple-booking-calendar' ); ?></a>

										</div>

									<?php endforeach; ?>


								<?php endif; ?>

							</div>


							<!-- Add iCal URL form -->
							<div class="inside">

								<!-- Calendar Name -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label"><?php echo __( 'Calendar Name', 'wp-simple-booking-calendar' ); ?> *</label>

									<div class="wpsbc-settings-field-inner">
										<input name="ical_url_import_name" type="text" value="" />
									</div>
									
								</div>

								<!-- iCal URL -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label"><?php echo __( 'iCalendar URL', 'wp-simple-booking-calendar' ); ?> *</label>

									<div class="wpsbc-settings-field-inner">
										<input name="ical_url_import_url" type="text" value="" />
									</div>
									
								</div>

								<!-- Set Legend Item -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label">
										<?php echo __( 'Import iCal Events As', 'wp-simple-booking-calendar' ); ?> *
									</label>

									<div class="wpsbc-settings-field-inner">

										<select name="ical_url_import_legend_item_default">
											<option value=""><?php echo __( 'Select...', 'wp-simple-booking-calendar' ); ?></option>
											<?php 
												foreach( $legend_items as $legend_item ) {
													echo '<option value="' . absint( $legend_item->get('id') ) . '">' . $legend_item->get('name') . '</option>';
												}
											?>
										</select>

									</div>

								</div>

								<!-- Use split days -->
								<div class="wpsbc-settings-field-wrapper">

									<label class="wpsbc-settings-field-label">
										<?php echo __( 'Use Split Days', 'wp-simple-booking-calendar' ); ?>
										
										<?php echo wpsbc_get_output_tooltip( __( 'If selected, the start and end dates of the iCalendar Events will be displayed as Split Days. You will have to chose the legends to be used below.', 'wp-simple-booking-calendar' ) ); ?>
										
									</label>

									<div class="wpsbc-settings-field-inner">

										<label for="ical_url_import_split_days">
											<input type="checkbox" id="ical_url_import_split_days" name="ical_url_import_split_days" value="1">
											Yes
										</label>

									</div>

								</div>

								<!-- Set Legend Item for Starting Split Day  -->
								<div class="wpsbc-settings-field-wrapper wpsbc-settings-field-wrapper-left wpsbc-settings-field-conditional">

									<label class="wpsbc-settings-field-label">
										<?php echo __( 'Split Day Start', 'wp-simple-booking-calendar' ); ?> *
									</label>

									<div class="wpsbc-settings-field-inner">

										<select name="ical_url_import_legend_item_split_day_start">
											<option value=""><?php echo __( 'Select...', 'wp-simple-booking-calendar' ); ?></option>
											<?php 
												foreach( $legend_items as $legend_item ) {
													echo '<option value="' . absint( $legend_item->get('id') ) . '">' . $legend_item->get('name') . '</option>';
												}
											?>
										</select>

									</div>

								</div>

								<!-- Set Legend Item for Ending Split Day  -->
								<div class="wpsbc-settings-field-wrapper wpsbc-settings-field-wrapper-right wpsbc-settings-field-conditional">

									<label class="wpsbc-settings-field-label">
										<?php echo __( 'Split Day End', 'wp-simple-booking-calendar' ); ?> *
									</label>

									<div class="wpsbc-settings-field-inner">

										<select name="ical_url_import_legend_item_split_day_end">
											<option value=""><?php echo __( 'Select...', 'wp-simple-booking-calendar' ); ?></option>
											<?php 
												foreach( $legend_items as $legend_item ) {
													echo '<option value="' . absint( $legend_item->get('id') ) . '">' . $legend_item->get('name') . '</option>';
												}
											?>
										</select>

									</div>

								</div>

								<div class="wpsbc-clear"><!-- --></div>

							</div><!-- / Add iCal URL form -->

							<!-- Card Bottom -->
							<div class="wpsbc-plugin-card-bottom plugin-card-bottom">

								<?php if( ! empty( $ical_feeds ) ): ?>
									<a onclick="return confirm('<?php echo __( 'Are you sure you want to refresh this iCal feeds?', 'wp-simple-booking-calendar' ); ?>');" href="<?php echo wp_nonce_url( add_query_arg( array( 'wpsbc_action' => 'refresh_ical_feeds' ), remove_query_arg( 'wpsbc_message' ) ), 'wpsbc_refresh_ical_feeds', 'wpsbc_token' ); ?>" class="button-secondary"><?php echo __( 'Refresh iCal Data', 'wp-simple-booking-calendar' );?></a>
								<?php endif; ?>

								<input type="submit" disabled class="button-primary wpsbc-float-right" value="<?php echo __( 'Add iCal URL', 'wp-simple-booking-calendar' ); ?>" />
								
								<div class="clear"><!-- --></div>

							</div>

							<!-- Calendar ID -->
							<input type="hidden" name="calendar_id" value="<?php echo $calendar_id; ?>" />

							<!-- Nonce -->
							<?php wp_nonce_field( 'wpsbc_ical_import_url', 'wpsbc_token', false ); ?>
							<input type="hidden" name="wpsbc_action" value="ical_import_url" />

						</form>

					</div>

				</div><!-- / Col-1-2 -->

			</div><!-- / Row -->

		</div>

	</div>

</div>