<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


class WPSBC_Shortcodes {

	/**
	 * Constructor
	 *
	 */
	public function __construct() {

		// Register the single calendar shortcode
		add_shortcode( 'wpsbc', array( __CLASS__, 'single_calendar' ) );

		// Register the calendar overview shortcode
		add_shortcode( 'wpsbc-overview', array( __CLASS__, 'calendar_overview' ) );

		// Register the search widget shortcode
		add_shortcode( 'wpsbc-search', array(__CLASS__, 'search_widget'));

	}

	/**
	 * The callback for the WPSBC single calendar shortcode
	 *
	 * @param array $atts
	 *
	 */
	public static function single_calendar( $atts ) {

		// Shortcode default attributes
		$default_atts = array(
			'id'	   		 => 0,
			'title'    		 => 'yes',
			'legend'   		 => 'yes',
			'legend_position'=> '',
			'dropdown' 		 => 'yes',
			'start'	   		 => 1,
			'display'  		 => 1,
			'language' 		 => 'auto',
			'month'	   		 => 0,
			'year'	   		 => 0,
			'jump'	   		 => 'no',
			'history'  		 => 1,
			'show_tooltip'   => 1,
			'weeknumbers' 	 => 'no',
			'highlighttoday' => 'no',
			'language'		 => 'auto',

			// Backwards Compatibility

			'tooltip' => null
		);

		

		// Shortcode attributes
		$atts = shortcode_atts( $default_atts, $atts );

		// Calendar outputter default arguments
		$default_args = wpsbc_get_calendar_output_default_args();

		$tooltip = (isset($atts['tooltip']) && $atts['tooltip'] !== null) ? $atts['tooltip'] : $atts['show_tooltip'];
		
		// Translating values from the shortcode attributes to the calendar arguments
		$args = array(
			'show_title'			   => ( ! empty( $atts['title'] ) && $atts['title'] == 'yes' ? 1 : 0 ),
			'months_to_show' 		   => (int)$atts['display'],
			'show_legend'			   => ( ! empty( $atts['legend'] ) && $atts['legend'] == 'yes' ? 1 : 0 ),
			'legend_position'		   => $atts['legend_position'],
			'start_weekday'	 		   => (int)$atts['start'],
			'show_selector_navigation' => ( ! empty( $atts['dropdown'] ) && $atts['dropdown'] == 'yes' ? 1 : 0 ),
			'show_week_numbers'		   => ( ! empty( $atts['weeknumbers'] ) && $atts['weeknumbers'] == 'yes' ? 1 : 0 ),
			'current_month'			   => ( ! empty( $atts['month'] ) ? (int)$atts['month'] : current_time('n') ),
			'current_year'			   => ( ! empty( $atts['year'] )  ? (int)$atts['year']  : current_time('Y') ),
			'jump_months'			   => ( ! empty( $atts['jump'] ) && $atts['jump'] == 'yes' ? 1 : 0 ),
			'highlight_today'		   => ( ! empty( $atts['highlighttoday'] ) && $atts['highlighttoday'] == 'yes' ? 1 : 0 ),
			'history'	 		   	   => (int)$atts['history'],
			'show_tooltip' 		   	   => (int)$tooltip,
			'language'		   		   => ( $atts['language'] == 'auto' ? wpsbc_get_locale() : $atts['language'] )
		);

		// Remove legend_position if it's empty
		if( empty( $args['legend_position'] ) )
			unset( $args['legend_position'] );

		// Calendar arguments
		$calendar_args = wp_parse_args( $args, $default_args );

		// Calendar id
		$calendar_id = ( ! empty( $atts['id'] ) ? (int)$atts['id'] : 0 );

		// Calendar
		$calendar = wpsbc_get_calendar( $calendar_id );

		if( is_null( $calendar ) ) {

			$output = '<p>' . __( 'Calendar does not exist.', 'wp-simple-booking-calendar' ) . '</p>';

		} else {

			// Initialize the calendar outputter
			$calendar_outputter = new WPSBC_Calendar_Outputter( $calendar, $calendar_args );

			$output = $calendar_outputter->get_display();

		}
	
		return $output;

	}


	/**
	 * The callback for the WPSBC calendar overview shortcode
	 *
	 * @param array $atts
	 *
	 */
	public static function calendar_overview( $atts ) {

		// Shortcode default attributes
		$default_atts = array(
			'calendars'	   	 => 'all',
			'legend'   		 => 'yes',
			'legend_position'=> 'side', 
			'language' 		 => 'auto',
			'start_month'	 => 0,
			'start_year'	 => 0,
			'history'  		 => 1,
			'show_tooltip'   => 1,
			'weeknumbers' 	 => 'no',
			'language'		 => 'auto',

			// Backwards compatibility
			'tooltip' => null
		);

		// Shortcode attributes
		$atts = shortcode_atts( $default_atts, $atts );

		// Calendar outputter default arguments
		$default_args = wpsbc_get_calendar_overview_output_default_args();

		$tooltip = (isset($atts['tooltip']) && $atts['tooltip'] !== null) ? $atts['tooltip'] : $atts['show_tooltip'];
		
		// Translating values from the shortcode attributes to the calendar arguments
		$args = array(
			'show_legend'			=> ( ! empty( $atts['legend'] ) && $atts['legend'] == 'yes' ? 1 : 0 ),
			'legend_position'		=> $atts['legend_position'],
			'show_day_abbreviation'	=> ( ! empty( $atts['weeknumbers'] ) && $atts['weeknumbers'] == 'yes' ? 1 : 0 ),
			'current_month'			=> ( ! empty( $atts['start_month'] ) ? (int)$atts['start_month'] : current_time('n') ),
			'current_year'			=> ( ! empty( $atts['start_year'] )  ? (int)$atts['start_year']  : current_time('Y') ),
			'history'	 		   	=> (int)$atts['history'],
			'show_tooltip'	 		=> (int)$tooltip,
			'language'		   		=> ( $atts['language'] == 'auto' ? wpsbc_get_locale() : $atts['language'] )
		);

		// Calendar arguments
		$calendar_args = wp_parse_args( $args, $default_args );

		// Calendars
		if( empty( $atts['calendars'] ) || $atts['calendars'] == 'all' ) {

			$args = apply_filters( 'wpsbc_calendar_overview_shortcode_all_calendars_args', array('status' => 'active') );

			$calendars = wpsbc_get_calendars( $args );

		} else {

			$calendar_ids = array_filter( array_map( 'trim', explode( ',', $atts['calendars'] ) ) );

			$args = array(
				'include' => $calendar_ids,
				'orderby' => 'FIELD( id, ' . implode( ',', $calendar_ids ) . ')',
				'order'   => ''
			);

			$calendars = wpsbc_get_calendars( $args );

		}


		if( empty( $calendars ) ) {

			$output = '<p>' . __( 'No calendars found.', 'wp-simple-booking-calendar' ) . '</p>';

		} else {

			// Initialize the calendar overview outputter
			$calendar_overview_outputter = new WPSBC_Calendar_Overview_Outputter( $calendars, $calendar_args );
			
			$output = $calendar_overview_outputter->get_display();

		}

		return $output;

	}

	/**
     * The callback for the Search Widget shortcode
     *
     * @param array $atts
     *
     */
    public static function search_widget($atts)
    {

        // Shortcode default attributes
        $default_atts = wpsbc_get_search_widget_default_args();

        // Shortcode attributes
        $atts = shortcode_atts($default_atts, $atts);

        $search_widget_outputter = new WPSBC_Search_Widget_Outputter($atts);

        return $search_widget_outputter->get_display();

    }

}

// Init shortcodes
new WPSBC_Shortcodes();