<?php
class WPSBC_Divi_Module_OverviewCalendar extends ET_Builder_Module
{

    public $slug = 'wpsbc_divi_overview_calendar';
    public $vb_support = 'on';

    public function init()
    {
        $this->name = esc_html__('Overview Calendar', 'wp-simple-booking-calendar');
    }

    public function get_fields()
    {

        // Start Year
        $start_year = array();
        $start_year['0-wpsbc-default'] = __('Current Year', 'wp-simple-booking-calendar');
        for ($i = date('Y'); $i <= date('Y') + 10; $i++) {
            $start_year[$i] = (string) $i;
        }

        // Start Month
        $start_month = array(
            '0-wpsbc-default' => __('Current Month', 'wp-simple-booking-calendar'),
            '1' => __('January', 'wp-simple-booking-calendar'),
            '2' => __('February', 'wp-simple-booking-calendar'),
            '3' => __('March', 'wp-simple-booking-calendar'),
            '4' => __('April', 'wp-simple-booking-calendar'),
            '5' => __('May', 'wp-simple-booking-calendar'),
            '6' => __('June', 'wp-simple-booking-calendar'),
            '7' => __('July', 'wp-simple-booking-calendar'),
            '8' => __('August', 'wp-simple-booking-calendar'),
            '9' => __('September', 'wp-simple-booking-calendar'),
            '10' => __('October', 'wp-simple-booking-calendar'),
            '11' => __('November', 'wp-simple-booking-calendar'),
            '12' => __('December', 'wp-simple-booking-calendar'),
        );

        // Languages
        $languages_dropdown = array();
        $settings = get_option('wpsbc_settings', array());
        $languages = wpsbc_get_languages();
        $active_languages = (!empty($settings['active_languages']) ? $settings['active_languages'] : array());

        $languages_dropdown['auto'] = __('Auto (let WP choose)', 'wp-simple-booking-calendar');

        foreach ($active_languages as $code) {
            $languages_dropdown[esc_attr($code)] = (!empty($languages[$code]) ? $languages[$code] : '');
        }


       

        return array(

            'legend' => array(
                'label' => esc_html__('Display Legend', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => 'yes',
                'option_category' => 'basic_option',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar'), 'no' => __('No', 'wp-simple-booking-calendar')),
            ),

            'legend_position' => array(
                'label' => esc_html__('Legend Position', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => 'top',
                'option_category' => 'basic_option',
                'options' => array('top' => __('Top', 'wp-simple-booking-calendar'), 'bottom' => __('Bottom', 'wp-simple-booking-calendar')),
            ),

            'start_year' => array(
                'label' => esc_html__('Start Year', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => '0-wpsbc-default',
                'option_category' => 'basic_option',
                'options' => $start_year,
            ),

            'start_month' => array(
                'label' => esc_html__('Start Month', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => '0-wpsbc-default',
                'option_category' => 'basic_option',
                'options' => $start_month,
            ),

            'history' => array(
                'label' => esc_html__('Show History', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => '1',
                'option_category' => 'basic_option',
                'options' => array(
                    '1' => __('Display booking history', 'wp-simple-booking-calendar'),
                    '2' => __('Replace booking history with the default legend item', 'wp-simple-booking-calendar'),
                    '3' => __('Use the Booking History Color from the Settings', 'wp-simple-booking-calendar'),
                ),
                'description' => __("This option lets you decide how past dates are being displayed for the user in the front-end.", 'wp-simple-booking-calendar'),
            ),

            'tooltip' => array(
                'label' => esc_html__('Display Tooltips', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => '1',
                'option_category' => 'basic_option',
                'options' => array(
                    '1' => __('No', 'wp-simple-booking-calendar'),
                    '2' => __('Yes', 'wp-simple-booking-calendar'),
                    '3' => __('Yes, with red indicator', 'wp-simple-booking-calendar'),
                ),
            ),

            'weeknumbers' => array(
                'label' => esc_html__('Show Day Abbreviations', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'option_category' => 'basic_option',
                'default' => 'no',
                'options' => array('yes' => __('Yes', 'wp-simple-booking-calendar'), 'no' => __('No', 'wp-simple-booking-calendar')),
                'description' => __("If set to yes, it will display at the beginning of each week the week's number counted from the beginning of the year.", 'wp-simple-booking-calendar'),
            ),

            'language' => array(
                'label' => esc_html__('Language', 'wp-simple-booking-calendar'),
                'type' => 'select',
                'default' => 'auto',
                'option_category' => 'basic_option',
                'options' => $languages_dropdown,
            ),

        );
    }

    public function render($attrs, $content = null, $render_slug = null)
    {
        $props = array();

        foreach($this->props as $key => $prop){
            $props[$key] = str_replace('0-wpsbc-default', '0', $prop);
        }

        return WPSBC_Shortcodes::calendar_overview($props);
    }
}

new WPSBC_Divi_Module_OverviewCalendar;
