<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Elementor_WPSBC_CalendarSearch extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'wpsbc_calendar_search';
    }

    public function get_title()
    {
        return esc_html__('WP Simple Booking Calendar - Search Widget', 'wp-simple-booking-calendar');
    }

    public function get_icon()
    {
        return 'eicon-search';
    }

    public function get_categories()
    {
        return ['wp-simple-booking-calendar'];
    }

    public function get_keywords()
    {
        return ['Search', 'Booking', 'Calendar', 'WP Simple Booking Calendar'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'search_settings',
            [
                'label' => esc_html__('Search Settings', 'wp-simple-booking-calendar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Widget Title', 'wp-simple-booking-calendar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'yes' => __('Yes', 'wp-simple-booking-calendar'),
                    'no' => __('No', 'wp-simple-booking-calendar')
                ],
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'results_per_page',
            [
                'label' => esc_html__('Results per Page', 'wp-simple-booking-calendar'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '10',
            ]
        );

        $this->add_control(
            'redirect',
            [
                'label' => esc_html__('Redirect URL', 'wp-simple-booking-calendar'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '',
            ]
        );

        // Get active languages
        $settings = get_option('wpsbc_settings', []);
        $languages = wpsbc_get_languages();
        $active_languages = (!empty($settings['active_languages']) ? $settings['active_languages'] : []);

        $languages_dropdown = ['auto' => __('Auto (let WP choose)', 'wp-simple-booking-calendar')];
        foreach ($active_languages as $code) {
            $languages_dropdown[$code] = (!empty($languages[$code]) ? $languages[$code] : '');
        }

        $this->add_control(
            'language',
            [
                'label' => esc_html__('Language', 'wp-simple-booking-calendar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $languages_dropdown,
                'default' => 'auto',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Execute the shortcode
        echo WPSBC_Shortcodes::search_widget($settings);
    }
}

// Register the widget
function register_wpsbc_calendar_search_widget($widgets_manager)
{
    require_once plugin_dir_path(__FILE__) . 'elementor-wpsbc-calendar-search.php';
    $widgets_manager->register_widget_type(new Elementor_WPSBC_CalendarSearch());
}
add_action('elementor/widgets/register', 'register_wpsbc_calendar_search_widget');
