<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Adds the "Add Calendar" button to the text editor
 *
 */
function wpsbc_add_calendar_shortcode_media_button() {

	if( ! function_exists( 'get_current_screen' ) )
		return;

	$screen = get_current_screen();

	if( is_null( $screen ) )
		return;

	/**
	 * Filter the post types where the shortcode media button should appear
	 *
	 * @param array
	 *
	 */
	$post_types = get_post_types(array('public' => true));
	
	$post_types = apply_filters( 'wpsbc_add_calendar_shortcode_media_button_post_types', $post_types );

	if( ! in_array( $screen->post_type, $post_types ) )
	    return;

	echo '<a href="#" id="wpsbc-shortcode-generator-button" class="button"><span class="dashicons dashicons-calendar-alt"></span>' . __( 'Add Calendar', 'wp-simple-booking-calendar' ) . '</a>';

}
add_action( 'media_buttons', 'wpsbc_add_calendar_shortcode_media_button', 20 );


/**
 * Adds the modal window triggered by the "Add Calendar" button
 *
 */
function wpsbc_add_calendar_shortcode_modal() {

	if( ! function_exists( 'get_current_screen' ) )
		return;

	$screen = get_current_screen();

	if( is_null( $screen ) )
		return;

	/**
	 * Filter the post types where the shortcode modal generated by the shortcode media button should appear
	 *
	 * @param array
	 *
	 */
	$post_types = get_post_types(array('public' => true));
	
	$post_types = apply_filters( 'wpsbc_add_calendar_shortcode_media_button_post_types', $post_types );

	if( ! in_array( $screen->post_type, $post_types ) )
	    return;
	
	include 'views/view-shortcode-generator.php';

}
add_action( 'admin_footer', 'wpsbc_add_calendar_shortcode_modal' );