<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class WPSBC_Widget_Calendar extends WP_Widget {

	/**
	 * Constructor
	 *
	 */
	public function __construct() {

		$widget_ops = array( 
			'classname'   => 'wpsbc_calendar',
			'description' => __( 'Insert a WP Simple Booking Calendar', 'wp-simple-booking-calendar' ),
		);

		parent::__construct( 'wpsbc_calendar', 'WP Simple Booking Calendar', $widget_ops );

	}

	/**
	 * Outputs the content of the widget
	 *
	 * @param array $args
	 * @param array $instance
	 *
	 */
	public function widget( $args, $instance ) {

		// Remove the "wpsbc" prefix to have a cleaner code
		$instance = ( ! empty( $instance ) && is_array( $instance ) ? $instance : array() );

		foreach( $instance as $key => $value ) {

			$instance[ str_replace( 'wpsbc_', '', $key ) ] = $value;
			unset( $instance[$key] );

		}

		if(!isset($instance['select_calendar'])){
			return false;
		}

		$calendar = wpsbc_get_calendar( absint( $instance['select_calendar'] ) );

		if(is_null($calendar)){
			return false;
		}

		$calendar_args = array(
			'show_title'      => ( ! empty( $instance['show_title'] ) && $instance['show_title'] == 'yes' ? 1 : 0 ),
			'show_legend'     => ( ! empty( $instance['show_legend'] ) && $instance['show_legend'] == 'yes' ? 1 : 0 ),
			'legend_position' => ( ! empty( $instance['legend_position'] ) ? $instance['legend_position'] : 'top' ),
			'start_weekday'   => ( ! empty( $instance['calendar_start'] ) ? absint( $instance['calendar_start'] ) : 1 ),
			'months_to_show'  => ( ! empty( $instance['calendar_view'] ) ? absint( $instance['calendar_view'] ) : 1 ),
			'language' 		  => ( ! empty( $instance['calendar_language'] ) ? ( $instance['calendar_language'] == 'auto' ? wpsbc_get_locale() : $instance['calendar_language'] ) : 'en' ),
			'current_year'    => ( ! empty( $instance['calendar_year'] ) ? $instance['calendar_year'] : current_time('Y') ),
			'current_month'   => ( ! empty( $instance['calendar_month'] ) ? $instance['calendar_month'] : current_time('n') ),
			'history' 		  => ( ! empty( $instance['calendar_history'] ) ? absint( $instance['calendar_history'] ) : 1 ),
			'show_tooltip'	  => ( ! empty( $instance['calendar_tooltip'] ) ? absint( $instance['calendar_tooltip'] ) : 1 ),
			'jump_months'     => ( ! empty( $instance['calendar_jump'] ) && $instance['calendar_jump'] == 'yes' ? 1 : 0 ),
			'highlight_today' 			=> ( ! empty( $instance['calendar_highlighttoday'] ) && $instance['calendar_highlighttoday'] == 'yes' ? 1 : 0 ),
			'show_week_numbers' 		=> ( ! empty( $instance['calendar_weeknumbers'] ) && $instance['calendar_weeknumbers'] == 'yes' ? 1 : 0 ),
			'show_selector_navigation'  => ( ! empty( $instance['show_dropdown'] ) && $instance['show_dropdown'] == 'yes' ? 1 : 0 )
		);

		$calendar_outputter = new WPSBC_Calendar_Outputter( $calendar, $calendar_args );

		echo $calendar_outputter->get_display();

	}

	/**
	 * Outputs the options form on admin
	 *
	 * @param array $instance The widget options
	 *
	 */
	public function form( $instance ) {
		
		global $wpdb;
        
        $calendar_id       = ( ! empty( $instance['wpsbc_select_calendar'] ) ? $instance['wpsbc_select_calendar'] : 0 );
        $show_title        = ( ! empty( $instance['wpsbc_show_title'] ) ? $instance['wpsbc_show_title'] : 'yes' );
        $show_legend       = ( ! empty( $instance['wpsbc_show_legend'] ) ? $instance['wpsbc_show_legend'] : 'yes' );
        $legend_position   = ( ! empty( $instance['wpsbc_legend_position'] ) ? $instance['wpsbc_legend_position'] : 'top' );
        $show_dropdown     = ( ! empty( $instance['wpsbc_show_dropdown'] ) ? $instance['wpsbc_show_dropdown'] : 'yes' );
        $calendar_view     = ( ! empty( $instance['wpsbc_calendar_view'] ) ? $instance['wpsbc_calendar_view'] : '1' );
        $calendar_start    = ( ! empty( $instance['wpsbc_calendar_start'] ) ? $instance['wpsbc_calendar_start'] : '1' );
        $calendar_language = ( ! empty( $instance['wpsbc_calendar_language'] ) ? $instance['wpsbc_calendar_language'] : 'en' );
        $calendar_month    = ( ! empty( $instance['wpsbc_calendar_month'] ) ? $instance['wpsbc_calendar_month'] : '0' );
        $calendar_year     = ( ! empty( $instance['wpsbc_calendar_year'] ) ? $instance['wpsbc_calendar_year'] : '0' );
        $calendar_history  = ( ! empty( $instance['wpsbc_calendar_history'] ) ? $instance['wpsbc_calendar_history'] : '1' );
        $calendar_tooltip  = ( ! empty( $instance['wpsbc_calendar_tooltip'] ) ? $instance['wpsbc_calendar_tooltip'] : 'no' );
        $calendar_weeknrs  = ( ! empty( $instance['wpsbc_calendar_weeknumbers'] ) ? $instance['wpsbc_calendar_weeknumbers'] : 'no' );
        $calendar_jump     = ( ! empty( $instance['wpsbc_calendar_jump'] ) ? $instance['wpsbc_calendar_jump'] : 'no' );
        $calendar_today    = ( ! empty( $instance['wpsbc_calendar_highlighttoday'] ) ? $instance['wpsbc_calendar_highlighttoday'] : 'no' );
        
        $calendars = wpsbc_get_calendars();

        ?>
        
        <!-- Calendar -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_select_calendar'); ?>"><?php echo __( 'Calendar', 'wp-simple-booking-calendar' ); ?></label>

			<select name="<?php echo $this->get_field_name('wpsbc_select_calendar'); ?>" id="<?php echo $this->get_field_id('wpsbc_select_calendar'); ?>" class="widefat">
				<?php foreach( $calendars as $calendar ):?>
					<option <?php echo ( $calendar->get('id') == $calendar_id ? 'selected="selected"' : '' );?> value="<?php echo $calendar->get('id'); ?>"><?php echo $calendar->get('name'); ?></option>
				<?php endforeach;?>
			</select>
		</p>

		<!-- Show Title -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_show_title'); ?>"><?php echo __( 'Display title', 'wp-simple-booking-calendar' );?></label>

			<select name="<?php echo $this->get_field_name('wpsbc_show_title'); ?>" id="<?php echo $this->get_field_id('wpsbc_show_title'); ?>" class="widefat">
				<option value="yes"><?php echo __( 'Yes', 'wp-simple-booking-calendar' ); ?></option>
				<option value="no" <?php echo ( $show_title == 'no' ? 'selected="selected"' : '' ); ?>><?php echo __( 'No', 'wp-simple-booking-calendar' );?></option>
			</select>
		</p>

		<!-- Show Legend -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_show_legend'); ?>"><?php echo __( 'Display legend', 'wp-simple-booking-calendar' );?></label>

			<select name="<?php echo $this->get_field_name('wpsbc_show_legend'); ?>" id="<?php echo $this->get_field_id('wpsbc_show_legend'); ?>" class="widefat">
				<option value="yes"><?php echo __( 'Yes', 'wp-simple-booking-calendar' ); ?></option>
				<option value="no" <?php echo ( $show_legend == 'no' ? 'selected="selected"' : '' ); ?>><?php echo __( 'No', 'wp-simple-booking-calendar' ); ?></option>
			</select>
		</p>

		<!-- Legend Position -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_legend_position'); ?>"><?php echo __( 'Legend Position', 'wp-simple-booking-calendar' );?></label>
			
			<select name="<?php echo $this->get_field_name('wpsbc_legend_position'); ?>" id="<?php echo $this->get_field_id('wpsbc_legend_position'); ?>" class="widefat">
				<option <?php echo ( $legend_position == 'side' ? 'selected="selected"' : '' ); ?> value="side"><?php echo __( 'Side', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $legend_position == 'top' ? 'selected="selected"' : '' ); ?> value="top"><?php echo __( 'Top', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $legend_position == 'bottom' ? 'selected="selected"' : '' ); ?> value="bottom"><?php echo __( 'Bottom', 'wp-simple-booking-calendar' );?></option>                        
			</select>
		</p>

		<!-- Show Dropdown -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_show_dropdown'); ?>"><?php echo __( 'Display dropdown?', 'wp-simple-booking-calendar' ); ?></label>

			<select name="<?php echo $this->get_field_name('wpsbc_show_dropdown'); ?>" id="<?php echo $this->get_field_id('wpsbc_show_dropdown'); ?>" class="widefat">
				<option value="yes"><?php echo __( 'Yes', 'wp-simple-booking-calendar' ); ?></option>
				<option value="no" <?php echo ( $show_dropdown == 'no' ? 'selected="selected"' : '' ); ?>><?php echo __( 'No', 'wp-simple-booking-calendar' ); ?></option>
			</select>
		</p>

		<!-- Calendar Start -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_calendar_start'); ?>"><?php echo __( 'Week starts on', 'wp-simple-booking-calendar' );?></label>

			<select name="<?php echo $this->get_field_name('wpsbc_calendar_start'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_start'); ?>" class="widefat">
				<option value="1" <?php echo ( $calendar_start == 1 ? 'selected="selected"' : '' ); ?>><?php echo __( 'Monday', 'wp-simple-booking-calendar' ); ?></option>
				<option value="2" <?php echo ( $calendar_start == 2 ? 'selected="selected"' : '' ); ?>><?php echo __( 'Tuesday', 'wp-simple-booking-calendar' ); ?></option>
				<option value="3" <?php echo ( $calendar_start == 3 ? 'selected="selected"' : '' ); ?>><?php echo __( 'Wednesday', 'wp-simple-booking-calendar' ); ?></option>
				<option value="4" <?php echo ( $calendar_start == 4 ? 'selected="selected"' : '' ); ?>><?php echo __( 'Thursday', 'wp-simple-booking-calendar' ); ?></option>
				<option value="5" <?php echo ( $calendar_start == 5 ? 'selected="selected"' : '' ); ?>><?php echo __( 'Friday', 'wp-simple-booking-calendar' ); ?></option>
				<option value="6" <?php echo ( $calendar_start == 6 ? 'selected="selected"' : '' ); ?>><?php echo __( 'Saturday', 'wp-simple-booking-calendar' ); ?></option>
				<option value="7" <?php echo ( $calendar_start == 7 ? 'selected="selected"' : '' ); ?>><?php echo __( 'Sunday', 'wp-simple-booking-calendar' ); ?></option>
			</select>
		</p>

		<!-- Months to Display -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_calendar_view'); ?>"><?php echo __( 'Months to display', 'wp-simple-booking-calendar' ); ?></label>

			<select name="<?php echo $this->get_field_name('wpsbc_calendar_view'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_view'); ?>" class="widefat">
				<?php for( $i = 1; $i <= 24; $i++ ): ?>
					<option value="<?php echo $i;?>" <?php echo ( $calendar_view == $i ? 'selected="selected"' : '' ); ?>><?php echo $i; ?></option>
				<?php endfor;?>
			</select>
		</p>

		<!-- Calendar Language -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_calendar_language'); ?>"><?php echo __( 'Language', 'wp-simple-booking-calendar' );?></label>

			<select name="<?php echo $this->get_field_name('wpsbc_calendar_language'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_language'); ?>" class="widefat">
				<?php
					$settings 		  = get_option( 'wpsbc_settings', array() );
					$languages 		  = wpsbc_get_languages();
					$active_languages = ( ! empty( $settings['active_languages'] ) ? $settings['active_languages'] : array() );
				?>

				<option value="auto"><?php echo __( 'Auto (let WP choose)', 'wp-simple-booking-calendar' );?></option>

				<?php foreach( $active_languages as $code ):?>
					<option value="<?php echo esc_attr( $code ); ?>" <?php echo ( $calendar_language == $code ? 'selected="selected"' : '' ); ?>><?php echo ( ! empty( $languages[$code] ) ? $languages[$code] : '' ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>

		<!-- Calendar Month -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_calendar_month'); ?>"><?php echo __( 'Start Month', 'wp-simple-booking-calendar' ); ?></label>
			
			<select name="<?php echo $this->get_field_name('wpsbc_calendar_month'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_month'); ?>" class="widefat">
				<option <?php echo ( $calendar_month == 0 ? 'selected="selected"' : '' ); ?> value="0"><?php echo __( 'Current Month', 'wp-simple-booking-calendar'); ?></option>
				<option <?php echo ( $calendar_month == 1 ? 'selected="selected"' : '' ); ?> value="1"><?php echo __('January', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 2 ? 'selected="selected"' : '' ); ?> value="2"><?php echo __( 'February', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 3 ? 'selected="selected"' : '' ); ?> value="3"><?php echo __( 'March', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 4 ? 'selected="selected"' : '' ); ?> value="4"><?php echo __( 'April', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 5 ? 'selected="selected"' : '' ); ?> value="5"><?php echo __( 'May', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 6 ? 'selected="selected"' : '' ); ?> value="6"><?php echo __( 'June', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 7 ? 'selected="selected"' : '' ); ?> value="7"><?php echo __( 'July', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 8 ? 'selected="selected"' : '' ); ?> value="8"><?php echo __( 'August', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 9 ? 'selected="selected"' : '' ); ?> value="9"><?php echo __( 'September', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 10 ? 'selected="selected"' : '' ); ?> value="10"><?php echo __( 'October', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 11 ? 'selected="selected"' : '' ); ?> value="11"><?php echo __( 'November', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_month == 12 ? 'selected="selected"' : '' ); ?> value="12"><?php echo __( 'December', 'wp-simple-booking-calendar' );?></option>   
			</select>
		</p>

		<!-- Calendar Year -->
		<p>    
			<label for="<?php echo $this->get_field_id('wpsbc_calendar_year'); ?>"><?php echo __( 'Start Year', 'wp-simple-booking-calendar' );?></label>
			
			<select name="<?php echo $this->get_field_name('wpsbc_calendar_year'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_year'); ?>" class="widefat">
				<option value="0"><?php echo __( 'Current Year', 'wp-simple-booking-calendar' ); ?></option>
				
				<?php for( $i = date('Y'); $i<= date('Y') + 10; $i++ ): ?>
					<option <?php echo ( $calendar_year == $i ? 'selected="selected"' : '' ); ?> value="<?php echo $i; ?>"><?php echo $i; ?></option>
				<?php endfor;?>      
			</select>
		</p>

		<!-- Calendar History -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_calendar_history'); ?>"><?php echo __( 'Show history', 'wp-simple-booking-calendar' );?></label>
			
			<select name="<?php echo $this->get_field_name('wpsbc_calendar_history'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_history'); ?>" class="widefat">
				<option <?php echo ( $calendar_history == 1 ? 'selected="selected"' : '' ); ?> value="1"><?php echo __( 'Display booking history', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_history == 2 ? 'selected="selected"' : '' ); ?> value="2"><?php echo __( 'Replace booking history with the default legend item', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_history == 3 ? 'selected="selected"' : '' ); ?> value="3"><?php echo __( 'Use the Booking History Color from the Settings', 'wp-simple-booking-calendar' );?></option>                        
			</select>
		</p>

		<!-- Calendar Tooltip -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_calendar_tooltip'); ?>"><?php echo __( 'Show Tooltip', 'wp-simple-booking-calendar' );?></label>
            
			<select name="<?php echo $this->get_field_name('wpsbc_calendar_tooltip'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_tooltip'); ?>" class="widefat">
				<option <?php echo ( $calendar_tooltip == 1 ? 'selected="selected"' : '' ); ?> value="1"><?php echo __( 'No', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_tooltip == 2 ? 'selected="selected"' : '' ); ?> value="2"><?php echo __( 'Yes', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_tooltip == 3 ? 'selected="selected"' : '' ); ?> value="3"><?php echo __( 'Yes, with red indicator', 'wp-simple-booking-calendar' );?></option>        
			</select>
        </p>

        <!-- Calendar Weeknumbers -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_calendar_weeknumbers'); ?>"><?php echo __( 'Show Week Numbers', 'wp-simple-booking-calendar' );?></label>
			
			<select name="<?php echo $this->get_field_name('wpsbc_calendar_weeknumbers'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_weeknumbers'); ?>" class="widefat">
				<option <?php echo ( $calendar_weeknrs == 'no' ? 'selected="selected"' : '' ); ?> value="no"><?php echo __( 'No', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_weeknrs == 'yes' ? 'selected="selected"' : '' ); ?> value="yes"><?php echo __( 'Yes', 'wp-simple-booking-calendar' );?></option>
			</select>
		</p>

		<!-- Calendar Jump -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_calendar_jump'); ?>"><?php echo __( 'Jump Switch', 'wp-simple-booking-calendar' );?></label>

			<select name="<?php echo $this->get_field_name('wpsbc_calendar_jump'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_jump'); ?>" class="widefat">
				<option <?php echo ( $calendar_jump == 'no' ? 'selected="selected"' : '' ); ?> value="no"><?php echo __( 'No', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_jump == 'yes' ? 'selected="selected"' : '' ); ?> value="yes"><?php echo __( 'Yes', 'wp-simple-booking-calendar' );?></option>
			</select>
		</p>

		<!-- Highlight Today -->
		<p>
			<label for="<?php echo $this->get_field_id('wpsbc_calendar_highlighttoday'); ?>"><?php echo __( 'Highlight Today', 'wp-simple-booking-calendar' );?></label>
			
			<select name="<?php echo $this->get_field_name('wpsbc_calendar_highlighttoday'); ?>" id="<?php echo $this->get_field_id('wpsbc_calendar_highlighttoday'); ?>" class="widefat">
				<option <?php echo ( $calendar_today == 'no' ? 'selected="selected"' : '' ); ?> value="no"><?php echo __( 'No', 'wp-simple-booking-calendar' );?></option>
				<option <?php echo ( $calendar_today == 'yes' ? 'selected="selected"' : '' ); ?> value="yes"><?php echo __( 'Yes', 'wp-simple-booking-calendar' );?></option>
			</select>
		</p>
        
        <?php

    }


	/**
	 * Processing widget options on save
	 *
	 * @param array $new_instance The new options
	 * @param array $old_instance The previous options
	 *
	 * @return array
	 *
	 */
	public function update( $new_instance, $old_instance ) {
		
		return $new_instance;

	}

}

add_action( 'widgets_init', function() {
	register_widget( 'WPSBC_Widget_Calendar' );
});